<?php

namespace App\Http\Controllers;

use App\Models\AppUser;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Brian2694\Toastr\Facades\Toastr;

class AppUserController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('AppUsers.AppUsers');
    }

    public function getUsers(Request $request)
    {
        if ($request->ajax()) {
            $data = AppUser::all();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('Status', function ($row) {
                    $color = $row->Status == 0 ? 'gray-300' : 'danger';
                    $text = $row->Status == 0 ? 'بلاک نشده' : 'بلاک شده';
                    $statusBtn = '<a href="'.route('appUsers.changeStatus', $row->IDD).'" class="btn text-nowrap btn-'.$color.'" onclick="return confirm(\'آیا مطمئن هستید؟\')">'.$text.'</a>'
                    .'<a> </a><a href="' . route('appusers.edit', $row) . '" class="btn text-nowrap btn-gray-300">
                                        <i></i>
                                        ویرایش سکه
                                    </a>';
                    return $statusBtn;
                })
                ->rawColumns(['Status'])
                ->make(true);
        }
    }

    public function changeStatus($id)
    {
        $user = AppUser::where('IDD', $id)->first();
        $newStatus = $user->Status == 0 ? 1 : 0;
        AppUser::where('IDD', $id)->update([
            'Status' => $newStatus,
        ]);
        if ($newStatus == 0)
            Toastr::success('کاربر '.$user->Username.' با موفقیت آنبلاک شد.','Success');
        else
            Toastr::success('کاربر '.$user->Username.' با موفقیت بلاک شد.','Success');
        return redirect()->back();
    }
    
    public function edit(AppUser $appuser)
    {
        return view('AppUsers.edit')->with('data', $appuser);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param $id
     */
    public function update(Request $request, AppUser $appuser)
    {
        // Validate
        $request->validate([
            'Coin_Follow' => 'required',
            'Coin_Other' => 'required'
        ]);
        try {
            // Update user information
            $appuser->update([
                'Coin_Follow' => $request['Coin_Follow'],
                'Coin_Other' => $request['Coin_Other']
            ]);
        } catch (\Exception $e) {
            Toastr::error('عملیات ویرایش با مشکل مواجه شد.', 'Error');
            return redirect()->back();
        }
        Toastr::success('سکه ها با موفقیت ویرایش شد.', 'Success');
        return redirect()->route('appUsers');
    }
}
