<?php

namespace App\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Spatie\Permission\Models\Permission;
use Yajra\DataTables\DataTables;

class PermissionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('Permissions.index');
    }

    public function getPermissions(Request $request)
    {
        if ($request->ajax()) {
            $data = Permission::select('name', 'id')->get();
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('Actions', function ($row) {
                    $actionBtn = '<button type="button" class="btn bg-transparent _r_btn border-0" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                </button>
                                <div class="dropdown-menu" x-placement="bottom-start">
                                    <a href="' . route('permissions.destroy', $row->id) . '" class="dropdown-item text-left" onclick="return confirm(\'آیا برای حذف مطمئن هستید؟\')">
                                        <i class="nav-icon i-Close-Window text-danger font-weight-bold mr-2"></i>
                                        حذف
                                    </a>
                                    <a href="' . route('permissions.edit', $row->id) . '" class="dropdown-item text-left">
                                        <i class="nav-icon i-Pen-2 font-weight-bold text-success mr-2"></i>
                                        ویرایش
                                    </a>
                                </div>';
                    return $actionBtn;
                })
                ->rawColumns(['Actions'])
                ->make(true);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('Permissions.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => ['required', 'unique:permissions']
        ]);
        try {
            Permission::create(['name' => $request->name]);
        } catch (Exception $e) {
            Toastr::error('عملیات افزودن دسترسی جدید با مشکل مواجه شد.', 'Error');
            return redirect()->back();
        }
        Toastr::success('دسترسی جدید با موفقیت ایجاد شد.', 'Success');
        return redirect()->route('permissions.index');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $permission = Permission::findById($id);
        return view('Permissions.edit', compact('permission'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param $id
     * @return RedirectResponse
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => ['required', 'unique:permissions,name,'.$id.'']
        ]);
        try {
            Permission::findById($id)->update(['name' => $request->name]);
        } catch (Exception $e) {
            Toastr::error('عملیات ویرایش دسترسی جدید با مشکل مواجه شد.', 'Error');
            return redirect()->back();
        }
        Toastr::success('دسترسی با موفقیت ویرایش شد.', 'Success');
        return redirect()->route('permissions.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return string
     */
    public function destroy($id)
    {
        $permission = Permission::findById($id);
        try {
            $permission->delete();
        } catch (Exception $e) {
            Toastr::error('عملیات حذف با مشکل مواجه شد.', 'Success');
            return redirect()->back();
        }
        Toastr::success('با موفقیت حذف شد.', 'Success');
        return redirect()->back();
    }
}
