<?php

namespace App\Http\Controllers;

use App\Models\Shop;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Brian2694\Toastr\Facades\Toastr;

class ShopController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('Shop.index');
    }

    public function getShop(Request $request)
    {
        if ($request->ajax()) {
            $data = Shop::all();
            return Datatables::of($data)
                ->addColumn('Status', function ($row) {
                    $actionBtn = '<button type="button" class="btn bg-transparent _r_btn border-0" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                </button>
                                <div class="dropdown-menu" x-placement="bottom-start">
                                    <a href="'.route('shop.destroy', $row->ID).'" class="dropdown-item text-left" onclick="return confirm(\'آیا برای حذف مطمئن هستید؟\')">
                                        <i class="nav-icon i-Close-Window text-danger font-weight-bold mr-2"></i>
                                        حذف
                                    </a>
                                    <a href="' . route('shop.edit', $row->ID) . '" class="dropdown-item text-left">
                                        <i class="nav-icon i-Pen-2 font-weight-bold text-success mr-2"></i>
                                        ویرایش
                                    </a>
                                </div>';
                    return $actionBtn;
                })->addColumn('Model', function ($row){
                    return $row->Model == 1 ? 'سکه مشترک' : 'سکه فالو';
                }) 
                ->rawColumns(['Status', 'Model'])
                ->make(true);
        }
    }

    public function changeStatus($id)
    {
        $user = Shop::where('ID', $id)->first();
        $newStatus = $user->Status == 0 ? 1 : 0;
        Shop::where('ID', $id)->update([
            'Status' => $newStatus,
        ]);
        if ($newStatus == 0)
            Toastr::success('کاربر '.$user->Username.' با موفقیت آنبلاک شد.','Success');
        else
            Toastr::success('کاربر '.$user->Username.' با موفقیت بلاک شد.','Success');
        return redirect()->back();
    }
    
    
    public function create()
    {
        return view('Shop.create');
    }
    
    public function edit(Shop $shop)
    {
        return view('Shop.edit')->with('data', $shop);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     */
    public function store(Request $request)
    {
        $request->validate([
            'Name' => 'required',
            'KeyMarket' => 'required',
            'USD' => 'required',
            'Price' => 'required',
            'Number_Buy' => 'required',
            'Number_Get' => 'required',
            'Model' => 'required'
        ]);
        $shop = new Shop();
        try {
            $shop->create([
                'Name' => $request->Name,
                'KeyMarket' => $request->KeyMarket,
                'USD' => (int)$request->USD,
                'Price' => (int)$request->Price,
                'Number_Buy' => (int)$request->Number_Buy,
                'Number_Get' => (int)$request->Number_Get,
                'Model' => (int)$request->Model,
            ]);
        } catch (\Exception $e) {
            Toastr::error('عملیات افزودن با مشکل مواجه شد.', 'Error');
            return redirect()->back();
        }
        Toastr::success('محصول جدید با موفقیت ایجاد شد.', 'Success');
        return redirect()->route('shop.index');
    }
    
    public function update(Request $request, Shop $shop)
    {
        $request->validate([
            'Name' => 'required',
            'KeyMarket' => 'required',
            'USD' => 'required',
            'Price' => 'required',
            'Number_Buy' => 'required',
            'Number_Get' => 'required',
            'Model' => 'required'
        ]);
        try {
            $shop->update([
                'Name' => $request->Name,
                'KeyMarket' => $request->KeyMarket,
                'USD' => (int)$request->USD,
                'Price' => (int)$request->Price,
                'Number_Buy' => (int)$request->Number_Buy,
                'Number_Get' => (int)$request->Number_Get,
                'Model' => (int)$request->Model,
            ]);
        } catch (\Exception $e) {
            Toastr::error('ویرایش با مشکل مواجه شد.', 'Error');
            return redirect()->back();
        }
        Toastr::success('محصول با موفقیت ویرایش شد.', 'Success');
        return redirect()->route('shop.index');
    }
    
    public function destroy(Shop $shop)
    {
        try {
            $shop->delete();
        } catch (\Exception $e) {
            Toastr::error('عملیات حذف با مشکل مواجه شد.', 'Success');
            return redirect()->back();
        }
        Toastr::success('محصول مورد نظر حذف گردید.', 'Success');
        return redirect()->back();
    }

}
