@extends('layouts.master')
@section('page-css')
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/toastr.css')}}">
@endsection

@section('main-content')
    <div class="breadcrumb">
        <h1>ادمین ها</h1>
        <ul>
            <li><a>ایجاد ادمین جدید</a></li>
        </ul>
    </div>

    <div class="separator-breadcrumb border-top"></div>

    <!-- begin::basic action bar -->
    <section class="basic-action-bar">
        <div class="">
            <!-- begin::main-row -->
            <div class="row">
                <div class="mb-3 col-md-6 col-12">
                    <div class="card">
                        <div class="card-header bg-transparent">
                            <h3 class="card-title">ویرایش مشخصات ادمین</h3>
                        </div>
                        <!--begin::form-->
                        <form action="{{ route('admins.update', $admin->id) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="card-body">
                                <div class="form-row">
                                    <div class="form-group col-12">
                                        <label for="name">نام</label>
                                        <input id="name" type="text"
                                               class="form-control-rounded form-control @error('name') is-invalid @enderror"
                                               name="name" value="{{ $admin->name }}" required autocomplete="name"
                                               autofocus>

                                        @error('name')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-12">
                                        <label for="email">آدرس ایمیل</label>
                                        <input id="email" type="email"
                                               class="form-control-rounded form-control @error('email') is-invalid @enderror"
                                               name="email" value="{{ $admin->email }}" required autocomplete="email">
                                        @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-12">
                                        <label for="permissions">دسترسی ها</label>
                                        <select id="permissions" name="permissions[]"
                                               class="form-control-rounded form-control @error('permissions') is-invalid @enderror" multiple="multiple">
                                            @foreach($permissions as $permission)
                                            <option @if($admin->hasPermissionTo($permission->name)) {{"selected"}} @endif>{{$permission->name}}</option>
                                            @endforeach
                                        </select>
                                        <span class="small">
                                            با استفاده از Ctrl + کلیک چپ، چند گزینه انتخاب کنید
                                        </span>
                                        @error('permissions')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-transparent">
                                <div class="mc-footer">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button type="submit" class="btn btn-primary m-1">ویرایش</button>
                                            <a href="{{route('admins.index')}}" class="btn btn-outline-secondary m-1">لغو</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <!-- end::form -->
                    </div>
                </div>
                <div class="mb-3 col-md-6 col-12">
                    <div class="card">
                        <div class="card-header bg-transparent">
                            <h3 class="card-title">تغییر رمز عبور</h3>
                        </div>
                        <!--begin::form-->
                        <form action="{{ route('admins.updatePassword', $admin->id) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="card-body">
                                <div class="form-row">
                                    <div class="form-group col-12">
                                        <label for="current_password">رمز عبور فعلی</label>
                                        <input id="current_password" type="password"
                                               class="form-control-rounded form-control @error('current_password') is-invalid @enderror"
                                               name="current_password" required>

                                        @error('current_password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-12">
                                        <label for="password">رمز عبور جدید</label>
                                        <input id="password" type="password"
                                               class="form-control-rounded form-control @error('password') is-invalid @enderror"
                                               name="password" required autocomplete="new-password">

                                        @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-12">
                                        <label for="password-confirm">تکرار رمز عبور</label>
                                        <input id="password-confirm" type="password"
                                               class="form-control-rounded form-control" name="password_confirmation"
                                               required autocomplete="new-password">
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-transparent">
                                <div class="mc-footer">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button type="submit" class="btn btn-primary m-1">تغییر رمز عبور</button>
                                            <a href="{{route('admins.index')}}" class="btn btn-outline-secondary m-1">لغو</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <!-- end::form -->
                    </div>
                </div>
            </div>
            <!-- end::main-row -->
        </div>
    </section>
    <!-- end::basic action bar -->
@endsection

@section('bottom-js')
    <script src="{{asset('assets/js/vendor/toastr.min.js')}}"></script>
    {!! Brian2694\Toastr\Facades\Toastr::message() !!}
@endsection
