@extends('layouts.master')
@section('page-css')
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/datatables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/toastr.css')}}">
@endsection

@section('main-content')
    <div class="breadcrumb">
        <h1>لیست ادمین ها</h1>
        <ul>
            <li>لیست ادمین ها</li>
        </ul>
    </div>
    <div class="separator-breadcrumb border-top"></div>
    <div class="row mb-4">
        <div class="col-md-12 mb-4">
            <div class="card text-left">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <h4 class="card-title mb-3">لیست ادمین ها</h4>
                        <a href="{{route('admins.create')}}" class="btn btn-primary">
                            افزودن ادمین جدید
                        </a>
                    </div>
                    <p>از ستون تنظیمات میتوانید پیام ها را حذف یا ویرایش کنید.</p>
                    <div class="table-responsive">
                        <table id="admins_datatable" class="display table table-striped table-borderless border yajra-datatable"
                               style="width:100%">
                            <thead>
                            <tr>
                                <th>No</th>
                                <th>نام</th>
                                <th>ایمیل</th>
                                <th>دسترسی</th>
                                <th>تنظیمات</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- end of col -->
    </div>
    <!-- end of row -->
@endsection

@section('page-js')
    <script type="text/javascript">
        $(function () {
            var table = $('#admins_datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admins.list') }}",
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                    {data: 'name', name: 'name'},
                    {data: 'email', name: 'email'},
                    {data: 'permissions', name: 'permissions'},
                    {data: 'Actions', name: 'Actions', orderable: false, searchable: false},
                ]
            });

        });
    </script>
    <script src="{{asset('assets/js/vendor/datatables.min.js')}}"></script>
    {{--    <script src="{{asset('assets/js/datatables.script.js')}}"></script>--}}
@endsection

@section('bottom-js')
    <script src="{{asset('assets/js/vendor/toastr.min.js')}}"></script>
    {!! Brian2694\Toastr\Facades\Toastr::message() !!}
@endsection
