@extends('layouts.master')
@section('page-css')
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/toastr.css')}}">
@endsection

@section('main-content')
    <div class="breadcrumb">
        <h1>کد هدیه</h1>
        <ul>
            <li><a>ایجاد کد هدیه</a></li>
        </ul>
    </div>

    <div class="separator-breadcrumb border-top"></div>

    <!-- begin::basic action bar -->
    <section class="basic-action-bar">
        <div class="">
            <!-- begin::main-row -->
            <div class="row">
                <!-- start default action bar -->
                <div class="mb-3 col-12">
                    <div class="card">
                        <div class="card-header bg-transparent">
                            <h3 class="card-title">ایجاد محصول جدید</h3>
                        </div>
                        <!--begin::form-->
                        <form action="{{ route('giftcode.store') }}" method="POST">
                            @csrf
                            <div class="card-body">
                                <div class="form-row ">
                                    
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">کد هدیه ( فقط حروف و اعداد انگلیسی ): </label>
                                        <input id="text" name="Code" class="form-control @error('Code') is-invalid @enderror"
                                                  placeholder="کد هدیه را وارد کنید" rows="1"></textarea>
                                        @error('Code')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">تعداد سکه هدیه : </label>
                                        <input id="text" name="Gift" class="form-control @error('Gift') is-invalid @enderror"
                                                  placeholder="تعداد سکه هدیه را وارد کنید" rows="1"></textarea>
                                        @error('Gift')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">مدل سکه هدیه ( 0 = سکه فالوئر | 1 = سکه مشترک | 2 = هر دو ): </label>
                                        <input id="text" name="ModelGift" class="form-control @error('ModelGift') is-invalid @enderror"
                                                  placeholder="مدل سکه هدیه را وارد کنید" rows="1"></textarea>
                                        @error('ModelGift')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">مدل کد هدیه ( 0 = چندتایی | 1 = تکی ): </label>
                                        <input id="text" name="Model" class="form-control @error('Model') is-invalid @enderror"
                                                  placeholder="مدل کد هدیه را وارد کنید" rows="1"></textarea>
                                        @error('Model')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    
                                </div>
                            </div>
                            <div class="card-footer bg-transparent">
                                <div class="mc-footer">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button type="submit" class="btn btn-primary m-1">افزودن</button>
                                            <a href="{{route('shop.index')}}" class="btn btn-outline-secondary m-1">لغو</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <!-- end::form -->
                    </div>
                </div>
                <!-- end default action bar -->
            </div>
            <!-- end::main-row -->
        </div>
    </section>
    <!-- end::basic action bar -->
@endsection

@section('bottom-js')
    <script src="{{asset('assets/js/vendor/toastr.min.js')}}"></script>
    {!! Brian2694\Toastr\Facades\Toastr::message() !!}
@endsection
