@extends('layouts.master')
@section('page-css')
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/toastr.css')}}">
@endsection

@section('main-content')
    <div class="breadcrumb">
        <h1>دسترسی ها</h1>
        <ul>
            <li><a>ایجاد دسترسی جدید</a></li>
        </ul>
    </div>

    <div class="separator-breadcrumb border-top"></div>

    <!-- begin::basic action bar -->
    <section class="basic-action-bar">
        <div class="">
            <!-- begin::main-row -->
            <div class="row">
                <!-- start default action bar -->
                <div class="mb-3 col-12">
                    <div class="card">
                        <div class="card-header bg-transparent">
                            <h3 class="card-title">ایجاد دسترسی جدید</h3>
                        </div>
                        <!--begin::form-->
                        <form action="{{ route('permissions.update', $permission->id) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="card-body">
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label for="name" class="ul-form__label">نام دسترسی</label>
                                        <input type="text" id="name" name="name" value="{{$permission->name}}" class="form-control @error('name') is-invalid @enderror">
                                        @error('name')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-transparent">
                                <div class="mc-footer">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button type="submit" class="btn btn-primary m-1">ویرایش</button>
                                            <a href="{{route('permissions.index')}}" class="btn btn-outline-secondary m-1">لغو</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <!-- end::form -->
                    </div>
                </div>
                <!-- end default action bar -->
            </div>
            <!-- end::main-row -->
        </div>
    </section>
    <!-- end::basic action bar -->
@endsection

@section('bottom-js')
    <script src="{{asset('assets/js/vendor/toastr.min.js')}}"></script>
    {!! Brian2694\Toastr\Facades\Toastr::message() !!}
@endsection
