@extends('layouts.master')
@section('page-css')
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/toastr.css')}}">
@endsection

@section('main-content')
    <div class="breadcrumb">
        <h1>فروشگاه</h1>
        <ul>
            <li><a>ایجاد محصول جدید</a></li>
        </ul>
    </div>

    <div class="separator-breadcrumb border-top"></div>

    <!-- begin::basic action bar -->
    <section class="basic-action-bar">
        <div class="">
            <!-- begin::main-row -->
            <div class="row">
                <!-- start default action bar -->
                <div class="mb-3 col-12">
                    <div class="card">
                        <div class="card-header bg-transparent">
                            <h3 class="card-title">ایجاد محصول جدید</h3>
                        </div>
                        <!--begin::form-->
                        <form action="{{ route('shop.store') }}" method="POST">
                            @csrf
                            <div class="card-body">
                                <div class="form-row ">
                                    
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">عنوان محصول: </label>
                                        <input id="text" name="Name" class="form-control @error('Name') is-invalid @enderror"
                                                  placeholder="عنوان محصول را وارد کنید" rows="1"></textarea>
                                        @error('Name')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">کلید مارکت : </label>
                                        <input id="text" name="KeyMarket" class="form-control @error('KeyMarket') is-invalid @enderror"
                                                  placeholder="کلید مارکت را وارد کنید" rows="1"></textarea>
                                        @error('KeyMarket')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">قیمت محصول (دلار): </label>
                                        <input id="text" name="USD" class="form-control @error('USD') is-invalid @enderror"
                                                  placeholder="قیمت محصول را وارد کنید" rows="1"></textarea>
                                        @error('USD')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">قیمت محصول (تومان): </label>
                                        <input id="text" name="Price" class="form-control @error('Price') is-invalid @enderror"
                                                  placeholder="قیمت محصول را وارد کنید" rows="1"></textarea>
                                        @error('Price')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">تعداد خرید : </label>
                                        <input id="text" name="Number_Buy" class="form-control @error('Number_Buy') is-invalid @enderror"
                                                  placeholder="تعداد خرید را وارد کنید" rows="1"></textarea>
                                        @error('Number_Buy')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">تعداد دریافت : </label>
                                        <input id="text" name="Number_Get" class="form-control @error('Number_Get') is-invalid @enderror"
                                                  placeholder="تعداد دریافت را وارد کنید" rows="1"></textarea>
                                        @error('Number_Get')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">مدل سکه ( 0 = سکه فالو | 1 = سکه مشترک ) : </label>
                                        <input id="text" name="Model" class="form-control @error('Model') is-invalid @enderror"
                                                  placeholder="مدل سکه" rows="1"></textarea>
                                        @error('Model')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    
                                </div>
                            </div>
                            <div class="card-footer bg-transparent">
                                <div class="mc-footer">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button type="submit" class="btn btn-primary m-1">افزودن</button>
                                            <a href="{{route('shop.index')}}" class="btn btn-outline-secondary m-1">لغو</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <!-- end::form -->
                    </div>
                </div>
                <!-- end default action bar -->
            </div>
            <!-- end::main-row -->
        </div>
    </section>
    <!-- end::basic action bar -->
@endsection

@section('bottom-js')
    <script src="{{asset('assets/js/vendor/toastr.min.js')}}"></script>
    {!! Brian2694\Toastr\Facades\Toastr::message() !!}
@endsection
