@extends('layouts.master')
@section('page-css')
  <link rel="stylesheet" href="{{asset('assets/styles/vendor/dropzone.min.css')}}">
@endsection

@section('main-content')
 <div class="breadcrumb">
                <h1>بارگزاری</h1>
                <ul>
                    <li><a href="">اجزاء</a></li>
                    <li>بارگزاری</li>
                </ul>
            </div>

            <div class="separator-breadcrumb border-top"></div>

            <div class="row mb-4">
                <div class="col-md-6">

                    <p>DropzoneJS is an open source library that provides drag’n’drop file uploads with image previews.</p>
                    <div class="alert alert-warning" role="alert">
                        <h4 class="alert-heading">خطا</h4>
                        <p></p>
                        <p class="mb-0">هشدار! Dropzone بارگذاری پرونده شما روی سرور را کنترل نمی کند. برای دریافت و ذخیره فایل خود باید کد را پیاده سازی کنید. برای اطلاعات بیشتر به بخش پیاده سازی سمت سرور مراجعه کنید.</p>
                    </div>
                </div>
            </div>
            <!-- end of row -->

            <div class="row mb-4">
                <div class="col-md-6 mb-4">
                    <div class="card text-left">

                        <div class="card-body">
                            <h4 class="card-title">بارگزاری تک</h4>
                            <form action="#" class="dropzone" id="single-file-upload">
                                <div class="fallback">
                                    <input name="file" type="file" />
                                </div>
                            </form>
                        </div>
                    </div>

                </div>
                <!-- end of col -->
                <div class="col-md-6 mb-4">
                    <div class="card text-left">

                        <div class="card-body">
                            <h4 class="card-title">بارگزاری چندتایی</h4>
                            <form action="#" class="dropzone" id="multple-file-upload">
                                <div class="fallback">
                                    <input name="file" type="file" multiple/>
                                </div>
                            </form>
                        </div>
                    </div>

                </div>
                <!-- end of col -->
                <div class="col-md-6 mb-4">
                    <div class="card text-left">

                        <div class="card-body">
                            <h4 class="card-title">استفاده از دکمه برای بارگزاری</h4>

                            <button id="button-select" class="btn btn-primary mb-1">انتخاب فایل ها</button>
                            <form action="#" class="dropzone dropzone-area" id="button-select-upload">
                                <div class="fallback">
                                    <input name="file" type="file" multiple />
                                </div>
                                <div class="dz-message">فایل را اینجا رها کنید تا آپلود شود</div>

                            </form>
                        </div>
                    </div>

                </div>
                <!-- end of col -->

                <div class="col-md-6 mb-4">
                    <div class="card text-left">

                        <div class="card-body">
                            <h4 class="card-title">اندازه پرونده و تعداد پرونده ها را محدود کنید</h4>


                            <form action="#" class="dropzone dropzone-area" id="file-limit-upload">

                                <div class="fallback">
                                    <input name="file" type="file" multiple />
                                </div>
                            </form>
                        </div>
                    </div>

                </div>
                <!-- end of col -->

                <div class="col-md-6 mb-4">
                    <div class="card text-left">

                        <div class="card-body">
                            <h4 class="card-title">پرونده های پذیرفته شده</h4>


                            <form action="#" class="dropzone dropzone-area" id="file-accepted-upload">

                                <div class="fallback">
                                    <input name="file" type="file" multiple />
                                </div>
                            </form>
                        </div>
                    </div>

                </div>
                <!-- end of col -->

                <div class="col-md-6 mb-4">
                    <div class="card text-left">

                        <div class="card-body">
                            <h4 class="card-title">تصویر کوچک را حذف کنید</h4>


                            <form action="#" class="dropzone dropzone-area" id="file-remove-thumbnail-upload">

                                <div class="fallback">
                                    <input name="file" type="file" multiple />
                                    <a class="btn btn-danger dz-remove" data-dz-remove>زباله</a>
                                </div>
                            </form>
                        </div>
                    </div>

                </div>
                <!-- end of col -->


            </div>
            <!-- end of row -->



@endsection

@section('page-js')

 <script src="{{asset('assets/js/vendor/dropzone.min.js')}}"></script>
<script src="{{asset('assets/js/dropzone.script.js')}}"></script>
@endsection
