<?php

use App\Http\Controllers\ShopController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AppUserController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\CalllController;
use App\Http\Controllers\GiftCodeController;
use App\Http\Controllers\BannerssController;
use App\Http\Controllers\ValuesBaseController;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware('auth')->group(function () {

    Route::view('/', 'starter')->name('firstPage');

    // ValuesBase
    Route::get('valuebase', [ValuesBaseController::class, 'index'])->name('valuebase')->middleware('permission:view valuebase|edit valuebase');
    Route::put('valuebase/update', [ValuesBaseController::class, 'update'])->name('valuebase.update')->middleware('permission:view valuebase|edit valuebase');

    // Calll
    Route::get('calll', [CalllController::class, 'index'])->name('calll')->middleware('permission:view calll|edit calll');
    Route::get('calll/list', [CalllController::class, 'getCalll'])->name('calll.list')->middleware('permission:view calll|edit calll');
    Route::get('calll/destroy/{calll}', [CalllController::class, 'destroy'])->name('calll.destroy')->middleware('permission:edit calll');

    // Reports
    Route::get('reports', [ReportsController::class, 'index'])->name('reports')->middleware('permission:view reports|edit reports');
    Route::get('reports/list', [ReportsController::class, 'getReports'])->name('reports.list')->middleware('permission:view reports|edit reports');
    Route::get('reports/destroy/{reports}', [ReportsController::class, 'destroy'])->name('reports.destroy')->middleware('permission:edit reports');

    // Users
    Route::get('appusers', [AppUserController::class, 'index'])->name('appUsers')->middleware('permission:view users|edit users');
    Route::get('appusers/list', [AppUserController::class, 'getUsers'])->name('appUsers.list')->middleware('permission:view users|edit users');
    Route::get('appusers/changeStatus/{id}', [AppUserController::class, 'changeStatus'])->name('appUsers.changeStatus')->middleware('permission:edit users');
    Route::get('appusers/edit/{appuser}', [AppUserController::class, 'edit'])->name('appusers.edit')->middleware('permission:edit users');
    Route::put('appusers/update/{appuser}', [AppUserController::class, 'update'])->name('appusers.update')->middleware('permission:edit users');

    // Shop
    Route::get('shop', [ShopController::class, 'index'])->name('shop.index')->middleware('permission:view shop|edit shop');
    Route::get('shop/create', [ShopController::class, 'create'])->name('shop.create')->middleware('permission:create shop');
    Route::post('shop/store', [ShopController::class, 'store'])->name('shop.store')->middleware('permission:create shop');
    Route::get('shop/edit/{shop}', [ShopController::class, 'edit'])->name('shop.edit')->middleware('permission:edit shop');
    Route::put('shop/update/{shop}', [ShopController::class, 'update'])->name('shop.update')->middleware('permission:edit shop');
    Route::get('shop/destroy/{shop}', [ShopController::class, 'destroy'])->name('shop.destroy')->middleware('permission:edit shop');
    Route::get('shop/list', [ShopController::class, 'getShop'])->name('shop.list')->middleware('permission:view shop|edit shop');

    // Banners
    Route::get('bannerss', [BannerssController::class, 'index'])->name('bannerss')->middleware('permission:view bannerss|edit bannerss');
    Route::post('bannerss/store', [BannerssController::class, 'store'])->name('bannerss.store')->middleware('permission:create bannerss');
    Route::get('bannerss/edit/{bannerss}', [BannerssController::class, 'edit'])->name('bannerss.edit')->middleware('permission:edit bannerss');
    Route::put('bannerss/update/{bannerss}', [BannerssController::class, 'update'])->name('bannerss.update')->middleware('permission:edit bannerss');
    Route::get('bannerss/destroy/{id}', [BannerssController::class, 'destroy'])->name('bannerss.destroy')->middleware('permission:edit bannerss');
    Route::get('bannerss/list', [BannerssController::class, 'getBanners'])->name('bannerss.list')->middleware('permission:view bannerss|edit bannerss');

    // GiftCode
    Route::get('giftcode', [GiftCodeController::class, 'index'])->name('giftcode.index')->middleware('permission:view giftcode|edit giftcode');
    Route::get('giftcode/create', [GiftCodeController::class, 'create'])->name('giftcode.create')->middleware('permission:create giftcode');
    Route::post('giftcode/store', [GiftCodeController::class, 'store'])->name('giftcode.store')->middleware('permission:create giftcode');
    Route::get('giftcode/destroy/{id}', [GiftCodeController::class, 'destroy'])->name('giftcode.destroy')->middleware('permission:edit giftcode');
    Route::get('giftcode/list', [GiftCodeController::class, 'getGiftCode'])->name('giftcode.list')->middleware('permission:view giftcode|edit giftcode');

    // Messages
    Route::prefix('messages')->group(function () {
        Route::get('/', [MessageController::class, 'index'])->name('messages.index')->middleware('permission:view messages|edit messages');
        Route::get('/create', [MessageController::class, 'create'])->name('messages.create')->middleware('permission:edit messages');
        Route::post('/store', [MessageController::class, 'store'])->name('messages.store')->middleware('permission:edit messages');
        Route::get('/edit/{message}', [MessageController::class, 'edit'])->name('messages.edit')->middleware('permission:edit messages');
        Route::put('/update/{message}', [MessageController::class, 'update'])->name('messages.update')->middleware('permission:edit messages');
        Route::get('/destroy/{message}', [MessageController::class, 'destroy'])->name('messages.destroy')->middleware('permission:edit messages');
        Route::get('/list', [MessageController::class, 'getMessages'])->name('messages.list')->middleware('permission:view messages|edit messages');
    });
    // Admins
    Route::get('admins', [AdminController::class, 'index'])->name('admins.index')->middleware('permission:view admins|edit admins');
    Route::get('admins/create', [AdminController::class, 'create'])->name('admins.create')->middleware('permission:edit admins');
    Route::post('admins/store', [AdminController::class, 'store'])->name('admins.store')->middleware('permission:edit admins');
    Route::get('admins/edit/{admin}', [AdminController::class, 'edit'])->name('admins.edit')->middleware('permission:edit admins');
    Route::put('admins/update/{admin}', [AdminController::class, 'update'])->name('admins.update')->middleware('permission:edit admins');
    Route::get('admins/destroy/{admin}', [AdminController::class, 'destroy'])->name('admins.destroy')->middleware('permission:edit admins');
    Route::get('admins/list', [AdminController::class, 'getAdmins'])->name('admins.list')->middleware('permission:view admins|edit admins');
    Route::put('admins/update-password/{admin}', [AdminController::class, 'updatePassword'])->name('admins.updatePassword')->middleware('permission:edit admins');

    // Permissions
    Route::prefix('permissions')->middleware('permission:admin permissions')->group(function () {
        Route::get('/', [PermissionController::class, 'index'])->name('permissions.index');
        Route::get('/create', [PermissionController::class, 'create'])->name('permissions.create');
        Route::post('/store', [PermissionController::class, 'store'])->name('permissions.store');
        Route::get('/edit/{admin}', [PermissionController::class, 'edit'])->name('permissions.edit');
        Route::put('/update/{admin}', [PermissionController::class, 'update'])->name('permissions.update');
        Route::get('/destroy/{admin}', [PermissionController::class, 'destroy'])->name('permissions.destroy');
        Route::get('/list', [PermissionController::class, 'getPermissions'])->name('permissions.list');
    });


    Route::get('large-compact-sidebar/dashboard/dashboard1', function () {
        // set layout sesion(key)
        session(['layout' => 'compact']);
        return view('dashboard.dashboardv1');
    })->name('compact');

    Route::get('large-sidebar/dashboard/dashboard1', function () {
        // set layout sesion(key)
        session(['layout' => 'normal']);
        return view('dashboard.dashboardv1');
    })->name('normal');

    Route::get('horizontal-bar/dashboard/dashboard1', function () {
        // set layout sesion(key)
        session(['layout' => 'horizontal']);
        return view('dashboard.dashboardv1');
    })->name('horizontal');

    Route::get('vertical/dashboard/dashboard1', function () {
        // set layout sesion(key)
        session(['layout' => 'vertical']);
        return view('dashboard.dashboardv1');
    })->name('vertical');

// sessions
    Route::view('sessions/signIn', 'sessions.signIn')->name('signIn');
    Route::view('sessions/signUp', 'sessions.signUp')->name('signUp');
    Route::view('sessions/forgot', 'sessions.forgot')->name('forgot');

});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
