<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(app()->getLocale() == 'en' ? 'ltr' : 'rtl'); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>پنل مدیریت | اسمارت موب</title>
    <link href="https://fonts.googleapis.com/css?family=Nunito:300,400,400i,600,700,800,900" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/styles/css/themes/lite-purple.min.css')); ?>">
</head>

<body>
<div class="auth-layout-wrap" style="background-image: url(<?php echo e(asset('assets/images/photo-wide-4.jpg')); ?>)">
    <div class="auth-content">
        <div class="card o-hidden">
            <div class="row">
                <div class="col-md-6">
                    <div class="p-4 text-left">
                        <div class="auth-logo text-center mb-4">
                            <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="">
                        </div>
                        <h1 class="mb-3 text-18">ورود</h1>
                        <form method="POST" action="<?php echo e(route('login')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for="email">آدرس ایمیل</label>
                                <input id="email" type="email"
                                       class="form-control form-control-rounded <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email"
                                       autofocus>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <label for="password">رمز عبور</label>
                                <input id="password" type="password"
                                       class="form-control form-control-rounded <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       name="password" required autocomplete="current-password">
                                <?php $__errorArgs = ['رمز عبور'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group ">
                                <div class="">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="remember"
                                               id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>

                                        <label class="form-check-label ml-3" for="remember">
                                            <?php echo e(__('یادآوری')); ?>

                                        </label>
                                    </div>
                                </div>
                            </div>

                            <button class="btn btn-rounded btn-primary btn-block mt-2">ورود</button>

                        </form>
                        <?php if(Route::has('password.request')): ?>

                            <div class="mt-3 text-center">

                                <a href="<?php echo e(route('password.request')); ?>" class="text-muted">
                                    <u>فراموشی رمز عبور ؟</u>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-6 text-center"
                     style="background-size: cover;background-image: url(<?php echo e(asset('assets/images/photo-long-3.jpg')); ?>">
                    
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo e(asset('assets/js/common-bundle-script.js')); ?>"></script>

<script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
</body>

</html>
<?php /**PATH D:\xampp\htdocs\gullmanager\resources\views/auth/login.blade.php ENDPATH**/ ?>