<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(app()->getLocale() == 'en' ? 'ltr' : 'rtl'); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>پنل مدیریت | اسمارت موب</title>
    <link href="https://fonts.googleapis.com/css?family=Nunito:300,400,400i,600,700,800,900" rel="stylesheet">
    <?php echo $__env->yieldContent('before-css'); ?>
    
    <link id="gull-theme" rel="stylesheet" href="<?php echo e(asset('assets/styles/css/themes/lite-purple.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/perfect-scrollbar.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/styles/css/custom.css')); ?>">

    <?php if(Session::get('layout')=="vertical"): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/fonts/fontawesome-free-5.10.1-web/css/all.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/styles/vendor/metisMenu.min.css')); ?>">

    <?php endif; ?>
    
    <?php echo $__env->yieldContent('page-css'); ?>
</head>


<body class="text-left">
<?php
    $layout = session('layout');
?>

<!-- Pre Loader Strat  -->
<div class='loadscreen' id="preloader">
    <div class="loader spinner-bubble spinner-bubble-primary"></div>
</div>
<!-- Pre Loader end  -->

<!-- ============ Compact Layout start ============= -->
<?php if($layout=="compact"): ?>

    <div class="app-admin-wrap layout-sidebar-compact sidebar-dark-purple sidenav-open clearfix">
    <?php echo $__env->make('layouts.compact-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- ============ end of left sidebar ============= -->


        <!-- ============ Body content start ============= -->
        <div class="main-content-wrap d-flex flex-column">
        <?php echo $__env->make('layouts.header-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- ============ end of header menu ============= -->
            <div class="main-content">
                <?php echo $__env->yieldContent('main-content'); ?>
            </div>

            
        </div>
        <!-- ============ Body content End ============= -->
    </div>
    <!--=============== End app-admin-wrap ================-->

    <!-- ============ Search UI Start ============= -->
    <?php echo $__env->make('layouts.search', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- ============ Search UI End ============= -->

    



    <!-- ============ Compact Layout End ============= -->











    <!-- ============ Horizontal Layout start ============= -->

<?php elseif($layout=="horizontal"): ?>

    <div class="app-admin-wrap layout-horizontal-bar clearfix">
    <?php echo $__env->make('layouts.header-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- ============ end of header menu ============= -->



    <?php echo $__env->make('layouts.horizontal-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- ============ end of left sidebar ============= -->

        <!-- ============ Body content start ============= -->
        <div class="main-content-wrap  d-flex flex-column">
            <div class="main-content">
                <?php echo $__env->yieldContent('main-content'); ?>
            </div>

            
        </div>
        <!-- ============ Body content End ============= -->
    </div>
    <!--=============== End app-admin-wrap ================-->

    <!-- ============ Search UI Start ============= -->
    <?php echo $__env->make('layouts.search', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- ============ Search UI End ============= -->

    


    <!-- ============ Horizontal Layout End ============= -->





    <!-- ============ Vetical SIdebar Layout start ============= -->
<?php elseif($layout=="vertical"): ?>
    <div class="app-admin-wrap layout-sidebar-vertical sidebar-full">
        <?php echo $__env->make('layouts.vertical.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="main-content-wrap  mobile-menu-content bg-off-white m-0">
            

            <div class="main-content pt-4">
                <?php echo $__env->yieldContent('main-content'); ?>
            </div>

            

        </div>

        <div class="sidebar-overlay open"></div>
    </div>

    <!-- ============ Vetical SIdebar Layout End ============= -->

    <!-- ============ Large SIdebar Layout start ============= -->
<?php elseif($layout=="normal"): ?>

    <div class="app-admin-wrap layout-sidebar-large clearfix">
    <?php echo $__env->make('layouts.header-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- ============ end of header menu ============= -->

    <?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- ============ end of left sidebar ============= -->

        <!-- ============ Body content start ============= -->
        <div class="main-content-wrap sidenav-open d-flex flex-column">
            <div class="main-content">
                <?php echo $__env->yieldContent('main-content'); ?>
            </div>

            
        </div>
        <!-- ============ Body content End ============= -->
    </div>
    <!--=============== End app-admin-wrap ================-->

    <!-- ============ Search UI Start ============= -->
    <?php echo $__env->make('layouts.search', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- ============ Search UI End ============= -->

    <!-- ============ Large Sidebar Layout End ============= -->

<?php else: ?>
    <!-- ============Deafult  Large SIdebar Layout start ============= -->

    
    <div class="app-admin-wrap layout-sidebar-large clearfix">
    <?php echo $__env->make('layouts.header-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- ============ end of header menu ============= -->

    <?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- ============ end of left sidebar ============= -->

        <!-- ============ Body content start ============= -->
        <div class="main-content-wrap sidenav-open d-flex flex-column">
            <div class="main-content">
                <?php echo $__env->yieldContent('main-content'); ?>
            </div>

            
        </div>
        <!-- ============ Body content End ============= -->
    </div>
    <!--=============== End app-admin-wrap ================-->

    <!-- ============ Search UI Start ============= -->
    <?php echo $__env->make('layouts.search', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- ============ Search UI End ============= -->

    


    <!-- ============ Large Sidebar Layout End ============= -->


<?php endif; ?>

<?php echo $__env->make('layouts.customizer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>




<script src="<?php echo e(asset('assets/js/common-bundle-script.js')); ?>"></script>


<script src="<?php echo e(asset('assets/js/vendor/sweetalert2.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/sweetalert.script.js')); ?>"></script>


<?php echo $__env->yieldContent('page-js'); ?>



<script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>


<?php if($layout=='compact'): ?>
    <script src="<?php echo e(asset('assets/js/sidebar.compact.script.js')); ?>"></script>


<?php elseif($layout=='normal'): ?>
    <script src="<?php echo e(asset('assets/js/sidebar.large.script.js')); ?>"></script>


<?php elseif($layout=='horizontal'): ?>
    <script src="<?php echo e(asset('assets/js/sidebar-horizontal.script.js')); ?>"></script>
<?php elseif($layout=='vertical'): ?>



    <script src="<?php echo e(asset('assets/js/tooltip.script.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/es5/script_2.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/feather.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/layout-sidebar-vertical.js')); ?>"></script>


<?php else: ?>
    <script src="<?php echo e(asset('assets/js/sidebar.large.script.js')); ?>"></script>

<?php endif; ?>


<script src="<?php echo e(asset('assets/js/customizer.script.js')); ?>"></script>




<?php echo $__env->yieldContent('bottom-js'); ?>
</body>

</html>
<?php /**PATH /home2/smartmob/public_html/InstaSmartNew/Manager/script/resources/views/layouts/master.blade.php ENDPATH**/ ?>