<?php

namespace App\Http\Controllers;

use App\Models\Bannerss;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Brian2694\Toastr\Facades\Toastr;

class BannerssController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('Bannerss.index');
    }

    public function getBanners(Request $request)
    {
        if ($request->ajax()) {
            $data = Bannerss::all();
            return Datatables::of($data)
                ->addColumn('Options', function ($row) {
                    $actionBtn = '<button type="button" class="btn bg-transparent _r_btn border-0" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                </button>
                                <div class="dropdown-menu" x-placement="bottom-start">
                                    <a href="'.route('bannerss.destroy', $row->ID).'" class="dropdown-item text-left" onclick="return confirm(\'آیا برای حذف مطمئن هستید؟\')">
                                        <i class="nav-icon i-Close-Window text-danger font-weight-bold mr-2"></i>
                                        حذف
                                    </a>
                                    <a href="' . route('bannerss.edit', $row) . '" class="dropdown-item text-left">
                                        <i class="nav-icon i-Pen-2 font-weight-bold text-success mr-2"></i>
                                        ویرایش
                                    </a>
                                </div>';
                    return $actionBtn;
                })->addColumn('part', function ($row){
                    if($row->part == 0){
                        return '<a class="btn text-nowrap btn-secondary">
                                        سفارش فالوئر
                                    </a>' ;
                    }else if($row->part == 1){
                        return '<a class="btn text-nowrap btn-primary">
                                        سفارش لایک
                                    </a>' ;
                    }else {
                        return '<a class="btn text-nowrap btn-light">
                                        سفارش کامنت
                                    </a>' ;
                    }
                })->addColumn('status', function ($row){
                    if($row->status == 0){
                        return '<a class="btn text-nowrap btn-warning">
                                        درحال انجام
                                    </a>' ;
                    }else if($row->status == 1){
                        return '<a class="btn text-nowrap btn-success">
                                       تکمیل شده
                                    </a>' ;
                    }else {
                        return '<a class="btn text-nowrap btn-danger">
                                       حذف شده
                                    </a>' ;
                    }
                })
                ->rawColumns(['Options', 'part', 'status'])
                ->make(true);
        }
    }
    
    public function edit(Bannerss $bannerss)
    {
        return view('Bannerss.edit')->with('data', $bannerss);
    }
    
    public function update(Request $request, Bannerss $bannerss)
    {
        $request->validate([
            'darkhasti' => 'required',
            'daryafti' => 'required',
            'status' => 'required'
        ]);
        try {
            $bannerss->update([
                'darkhasti' => $request->darkhasti,
                'daryafti' => $request->daryafti,
                'status' => $request->status,
            ]);
        } catch (\Exception $e) {
            Toastr::error('ویرایش با مشکل مواجه شد.', 'Error');
            return redirect()->back();
        }
        Toastr::success('سفارش با موفقیت ویرایش شد.', 'Success');
        return redirect()->route('bannerss');
    }
    
    public function destroy($id)
    {
        try {
            $banners = Bannerss::where('ID', $id)->first();
            $banners->delete();
        } catch (\Exception $e) {
            Toastr::error('عملیات حذف با مشکل مواجه شد.', 'Success');
            return redirect()->back();
        }
        Toastr::success('سفارش مورد نظر حذف گردید.', 'Success');
        return redirect()->back();
    }

}
