<?php

namespace App\Http\Controllers;

use App\Models\Calll;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Brian2694\Toastr\Facades\Toastr;

class CalllController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('Calll.index');
    }

    public function getCalll(Request $request)
    {
        if ($request->ajax()) {
            $data = Calll::all();
            return Datatables::of($data)
                ->addColumn('Status', function ($row) {
                    $actionBtn = '<button type="button" class="btn bg-transparent _r_btn border-0" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                </button>
                                <div class="dropdown-menu" x-placement="bottom-start">
                                    <a href="'.route('calll.destroy', $row->ID).'" class="dropdown-item text-left" onclick="return confirm(\'آیا برای حذف مطمئن هستید؟\')">
                                        <i class="nav-icon i-Close-Window text-danger font-weight-bold mr-2"></i>
                                        حذف
                                    </a>
                                </div>';
                    return $actionBtn;
                })->rawColumns(['Status'])
                ->make(true);
        }
    }

    public function destroy(Calll $calll)
    {
        try {
            $calll->delete();
        } catch (\Exception $e) {
            Toastr::error('عملیات حذف با مشکل مواجه شد.', 'Success');
            return redirect()->back();
        }
        Toastr::success('محصول مورد نظر حذف گردید.', 'Success');
        return redirect()->back();
    }

}
