<?php

namespace App\Http\Controllers;

use App\Models\GiftCode;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Brian2694\Toastr\Facades\Toastr;

class GiftCodeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('GiftCode.index');
    }

    public function getGiftCode(Request $request)
    {
        if ($request->ajax()) {
            $data = GiftCode::all();
            return Datatables::of($data)
                ->addColumn('Status', function ($row) {
                    $actionBtn = '<button type="button" class="btn bg-transparent _r_btn border-0" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                </button>
                                <div class="dropdown-menu" x-placement="bottom-start">
                                    <a href="'.route('giftcode.destroy', $row->ID).'" class="dropdown-item text-left" onclick="return confirm(\'آیا برای حذف مطمئن هستید؟\')">
                                        <i class="nav-icon i-Close-Window text-danger font-weight-bold mr-2"></i>
                                        حذف
                                    </a>
                                </div>';
                    return $actionBtn;
                })->addColumn('Model', function ($row){
                    return $row->Model == 0 ? 'چندتایی' : 'تکی';
                })->addColumn('ModelGift', function ($row){
                    $a = $row->ModelGift ;
                    if($a === "0"){
                        return 'سکه فالو';
                    }else if($a === "1"){
                        return 'سکه مشترک';
                    }else {
                        return 'سکه فالو و مشترک';
                    }
                })
                ->rawColumns(['Model', 'ModelGift', 'Status'])
                ->make(true);
        }
    }
    
    
    public function create()
    {
        return view('GiftCode.create');
    }
    

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     */
    public function store(Request $request)
    {
        $request->validate([
            'Code' => 'required',
            'Gift' => 'required',
            'ModelGift' => 'required',
            'Model' => 'required'
        ]);
        $giftCode = new GiftCode();
        try {
            $giftCode->create([
                'Code' => $request->Code,
                'Users' => '',
                'Gift' => (int)$request->Gift,
                'ModelGift' => (int)$request->ModelGift,
                'Model' => (int)$request->Model,
            ]);
        } catch (\Exception $e) {
            Toastr::error('عملیات افزودن با مشکل مواجه شد.', 'Error');
            return redirect()->back();
        }
        Toastr::success('کد هدیه جدید با موفقیت ایجاد شد.', 'Success');
        return redirect()->route('giftcode.index');
    }
    
    public function destroy($id)
    {
        try {
            $giftCode = GiftCode::where('ID', $id)->first();
            $giftCode->delete();
        } catch (\Exception $e) {
            Toastr::error('عملیات حذف با مشکل مواجه شد.', 'Success');
            return redirect()->back();
        }
        Toastr::success('کد هدیه مورد نظر حذف گردید.', 'Success');
        return redirect()->back();
    }

}
