<?php

namespace App\Http\Controllers;

use App\Models\Message;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Brian2694\Toastr\Facades\Toastr;

class MessageController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('Messages.index');
    }

    public function getMessages(Request $request)
    {
        if ($request->ajax()) {
            $data = Message::all();
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('Actions', function ($row) {
                    $actionBtn = '<button type="button" class="btn bg-transparent _r_btn border-0" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                    <span class="_dot _r_block-dot bg-dark"></span>
                                </button>
                                <div class="dropdown-menu" x-placement="bottom-start">
                                    <a href="'.route('messages.destroy', $row->ID).'" class="dropdown-item text-left" onclick="return confirm(\'آیا برای حذف مطمئن هستید؟\')">
                                        <i class="nav-icon i-Close-Window text-danger font-weight-bold mr-2"></i>
                                        حذف
                                    </a>
                                    <a href="' . route('messages.edit', $row->ID) . '" class="dropdown-item text-left">
                                        <i class="nav-icon i-Pen-2 font-weight-bold text-success mr-2"></i>
                                        ویرایش
                                    </a>
                                </div>';
                    return $actionBtn;
                })
                ->rawColumns(['Actions'])
                ->make(true);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('Messages.create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     */
    public function store(Request $request)
    {
        $request->validate([
            'user' => 'required',
            'text' => 'required'
        ]);
        $message = new Message();
        try {
            $message->create([
                'User' => $request->user,
                'Text' => $request->text,
                'Date' => date('Y/m/d h:i'),
            ]);
        } catch (\Exception $e) {
            Toastr::error('عملیات افزودن پیام جدید با مشکل مواجه شد.', 'Error');
            return redirect()->back();
        }
        Toastr::success('پیام جدید با موفقیت ایجاد شد.', 'Success');
        return redirect()->route('messages.index');
    }

    /**
     * Display the specified resource.
     * @param Message $message
     */
    public function show(Message $message)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     * @param Message $message
     */
    public function edit(Message $message)
    {
        return view('Messages.edit')->with('data', $message);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param Message $message
     */
    public function update(Request $request, Message $message)
    {
        $request->validate([
            'user' => 'required',
            'text' => 'required'
        ]);
        try {
            $message->update([
                'User' => $request->user,
                'Text' => $request->text,
//                'Date' => date('Y/m/d h:i'),
            ]);
        } catch (\Exception $e) {
            Toastr::error('ویرایش پیام با مشکل مواجه شد.', 'Error');
            return redirect()->back();
        }
        Toastr::success('پیام با موفقیت ویرایش شد.', 'Success');
        return redirect()->route('messages.index');
    }

    /**
     * Remove the specified resource from storage.
     * @param Message $message
     */
    public function destroy(Message $message)
    {
        try {
            $message->delete();
        } catch (\Exception $e) {
            Toastr::error('عملیات حذف با مشکل مواجه شد.', 'Success');
            return redirect()->back();
        }
        Toastr::success('پیام مورد نظر حذف گردید.', 'Success');
        return redirect()->back();
    }
}
