<?php

namespace App\Http\Controllers;

use App\Models\ValuesBase;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Brian2694\Toastr\Facades\Toastr;

class ValuesBaseController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $valuesBase = ValuesBase::all();
        return view('ValuesBase.index', compact('valuesBase'));
    }

    public function getValuesBase(Request $request)
    {
        if ($request->ajax()) {
            $data = ValuesBase::all();
            return Datatables::of($data)
                ->addColumn('Value', function ($row) {
                    $actionBtn = '<textarea id="text" name="' . $row->Name . '" class="form-control "
                                                  placeholder="اطلاعات را وارد کنید" rows="4">' . $row->Value . '</textarea>';
                    return $actionBtn;
                })->rawColumns(['Value'])
                ->make(true);
        }
    }

    public function update(Request $request)
    {
        try {
            foreach ($request->all() as $key => $value) {
                $models = ValuesBase::where('Name', $key);
                $models->update(['Value' => $value]);
            }
        } catch (\Exception $e) {
            Toastr::error('ویرایش با مشکل مواجه شد.', 'Error');
            return redirect()->back();
        }
        Toastr::success('محصول با موفقیت ویرایش شد.', 'Success');
        return redirect()->back();
    }

}
