@extends('layouts.master')
@section('page-css')
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/toastr.css')}}">
@endsection

@section('main-content')
    <div class="breadcrumb">
        <h1>ادمین ها</h1>
        <ul>
            <li><a>ایجاد ادمین جدید</a></li>
        </ul>
    </div>

    <div class="separator-breadcrumb border-top"></div>

    <!-- begin::basic action bar -->
    <section class="basic-action-bar">
        <div class="">
            <!-- begin::main-row -->
            <div class="row">
                <div class="mb-3 col-md-6 col-12">
                    <div class="card">
                        <div class="card-header bg-transparent">
                            <h3 class="card-title">ویرایش مشخصات ادمین</h3>
                        </div>
                        <!--begin::form-->
                        <form action="{{ route('appusers.update', $data->IDD) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="card-body">
                                <div class="form-row">
                                    <div class="form-group col-12">
                                        <label for="user">سکه فالو</label>
                                        <input id="text" type="text"
                                               class="form-control-rounded form-control @error('Coin_Follow') is-invalid @enderror"
                                               name="Coin_Follow" value="{{ $data->Coin_Follow }}" required autocomplete="Coin_Follow"
                                               autofocus>

                                        @error('Coin_Follow')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-12">
                                        <label for="user">سکه مشترک</label>
                                        <input id="text" type="text"
                                               class="form-control-rounded form-control @error('Coin_Other') is-invalid @enderror"
                                               name="Coin_Other" value="{{ $data->Coin_Other }}" required autocomplete="Coin_Other">
                                        @error('Coin_Other')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-transparent">
                                <div class="mc-footer">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button type="submit" class="btn btn-primary m-1">ویرایش</button>
                                            <a href="{{route('appUsers')}}" class="btn btn-outline-secondary m-1">لغو</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <!-- end::form -->
                    </div>
                </div>
            </div>
            <!-- end::main-row -->
        </div>
    </section>
    <!-- end::basic action bar -->
@endsection

@section('bottom-js')
    <script src="{{asset('assets/js/vendor/toastr.min.js')}}"></script>
    {!! Brian2694\Toastr\Facades\Toastr::message() !!}
@endsection
