@extends('layouts.master')
@section('page-css')
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/toastr.css')}}">
@endsection

@section('main-content')
    <div class="breadcrumb">
        <h1>پیام ها</h1>
        <ul>
            <li><a>ایجاد پیام جدید</a></li>
        </ul>
    </div>

    <div class="separator-breadcrumb border-top"></div>

    <!-- begin::basic action bar -->
    <section class="basic-action-bar">
        <div class="">
            <!-- begin::main-row -->
            <div class="row">
                <!-- start default action bar -->
                <div class="mb-3 col-12">
                    <div class="card">
                        <div class="card-header bg-transparent">
                            <h3 class="card-title">ایجاد پیام جدید</h3>
                        </div>
                        <!--begin::form-->
                        <form action="{{ route('messages.store') }}" method="POST">
                            @csrf
                            <div class="card-body">
                                <div class="form-row ">
                                    <div class="form-group col-md-12">
                                        <label for="text" class="ul-form__label">متن پیام : </label>
                                        <textarea id="text" name="text" class="form-control @error('text') is-invalid @enderror"
                                                  placeholder="متن پیام را وارد کنید" rows="4"></textarea>
                                        @error('text')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label for="user" class="ul-form__label">User : </label>
                                        <input id="text" name="user" type="text" class="form-control @error('user') is-invalid @enderror"
                                               placeholder="E.g. all">
                                        @error('user')
                                        <small class="ul-form__text form-text text-danger">
                                            {{$message}}
                                        </small>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-transparent">
                                <div class="mc-footer">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button type="submit" class="btn btn-primary m-1">افزودن</button>
                                            <a href="{{route('messages.index')}}" class="btn btn-outline-secondary m-1">لغو</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <!-- end::form -->
                    </div>
                </div>
                <!-- end default action bar -->
            </div>
            <!-- end::main-row -->
        </div>
    </section>
    <!-- end::basic action bar -->
@endsection

@section('bottom-js')
    <script src="{{asset('assets/js/vendor/toastr.min.js')}}"></script>
    {!! Brian2694\Toastr\Facades\Toastr::message() !!}
@endsection
