@extends('layouts.master')
@section('page-css')
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/datatables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/toastr.css')}}">
@endsection

@section('main-content')
    <div class="breadcrumb">
        <h1>لیست محصولات</h1>
        <ul>
            <li>لیست محصولات</li>
        </ul>
    </div>
    <div class="separator-breadcrumb border-top"></div>
    <div class="row mb-4">
        <div class="col-md-12 mb-4">
            <div class="card text-left">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="shop_datatable"
                               class="display table table-striped table-borderless border yajra-datatable"
                               style="width:100%">
                            <thead>
                            <tr>
                                <th>آیدی</th>
                                <th>عنوان</th>
                                <th>کلید مارکت</th>
                                <th>قیمت (دلار)</th>
                                <th>قیمت (تومان)</th>
                                <th>تعداد خرید</th>
                                <th>تعداد دریافت</th>
                                <th>مدل سکه</th>
                                <th>تنظیمات</th>
                            </tr>
                            </thead>
                            <tbody dir="ltr">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- end of col -->
    </div>
    <!-- end of row -->
@endsection

@section('page-js')
    <script type="text/javascript">
        $(function () {
            var table = $('#shop_datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('shop.list') }}",
                columns: [
                    {data: 'ID', name: 'ID'},
                    {data: 'Name', name: 'Name'},
                    {data: 'KeyMarket', name: 'KeyMarket'},
                    {data: 'USD', name: 'USD'},
                    {data: 'Price', name: 'Price'},
                    {data: 'Number_Buy', name: 'Number_Buy'},
                    {data: 'Number_Get', name: 'Number_Get'},
                    {data: 'Model', name: 'Model'},
                    {data: 'Status', name: 'Status', orderable: false, searchable: false},
                ]
            });

        });
    </script>
    <script src="{{asset('assets/js/vendor/datatables.min.js')}}"></script>
    {{--    <script src="{{asset('assets/js/datatables.script.js')}}"></script>--}}
@endsection

@section('bottom-js')
    <script src="{{asset('assets/js/vendor/toastr.min.js')}}"></script>
    {!! Brian2694\Toastr\Facades\Toastr::message() !!}

    
@endsection
