@extends('layouts.master')
@section('page-css')
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/datatables.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/styles/vendor/toastr.css')}}">
@endsection

@section('main-content')
    <div class="breadcrumb">
        <h1>اطلاعات پایه</h1>
        <ul>
            <li>اطلاعات پایه</li>
        </ul>
    </div>
    <div class="separator-breadcrumb border-top"></div>
    <div class="row mb-4">
        <div class="col-md-12 mb-4">
            <div class="card text-left">
                <div class="card-body">
                    <div class="card-title">
                        اطلاعات پایه
                    </div>
                    <form action="{{route('valuebase.update')}}" method="POST">
                        @csrf
                        @method('PUT')
                        @foreach($valuesBase as $vb)
                            <div class="form-group">
                                <label for="input-{{$vb->ID}}">{{$vb->Descript}}</label>
                                <input type="text" id="input-{{$vb->ID}}" name="{{$vb->Name}}"
                                       class="form-control form-control-rounded @error('email') is-invalid @enderror"
                                       value="{{$vb->Value}}" dir="ltr" required
                                >
                                @error($vb->Name)
                                <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                @enderror
                            </div>
                        @endforeach
                        <div class="mt-5 text-center">
                            <button class="btn btn-primary" type="submit">ویرایش</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- end of col -->
    </div>
    <!-- end of row -->
@endsection

@section('bottom-js')
    <script src="{{asset('assets/js/vendor/toastr.min.js')}}"></script>
    {!! Brian2694\Toastr\Facades\Toastr::message() !!}
@endsection
